import numpy as np
from util import feasibility_check, optimal_solution

class Experiment:
    def __init__(self):
        self.dist = "Gaussian"
        self.M = 2
        self.K = 4
        self.b = 0.5
        self.d = 7

        self.theta = np.array([1.0, 0.0, 0.0, 0.0, 1.0, 1.2, 0.0])
        self.beta = np.array([0.45, 0.0, 0.0, 0.0, 0.0, 0.6, 0.8])
        self.design_indices = [(0,0), (0,1), (0,2), (0,3),
                               (1,0), (1,1), (1,2)]
        self.design_phi = np.eye(self.d)
        self.phi = self.construct_feature_exp()
        self.f = self.phi @ self.theta
        self.g = self.phi @ self.beta
        np.random.seed(42)
        self.variance = np.random.uniform(low=0.5, high=1.0, size=np.shape(self.f))
        self.std = np.sqrt(self.variance)
        m_indices, k_indices = zip(*self.design_indices)
        self.design_var = self.variance[m_indices, k_indices]
        self.feasibility = feasibility_check(self.M, self.K, self.g, self.b)
        self.opt_solution = optimal_solution(self.M, self.f, self.feasibility)

    def construct_feature_exp(self):
        vec = np.zeros(self.d)
        vec[0] = np.cos(0.4)
        vec[1] = np.sin(0.4)
        vec_reshaped = vec.reshape(1, -1)
        combined_array = np.vstack((self.design_phi, vec_reshaped))
        phi = combined_array.reshape((self.M, self.K, self.d))
        return phi

    def generate_samples(self, context, design):
        F = np.random.normal(loc = self.f[context, design], scale = self.std[context, design])
        G = np.random.normal(loc = self.g[context, design], scale = self.std[context, design])

        return F, G
